<?php
/*
|--------------------------------------------------------------------------
| ColibriPlus - The Ultimate Social Network Web Application.
|--------------------------------------------------------------------------
| Author: Mansur Terla. Full-Stack Web Developer, UI/UX Designer.
| Website: www.terla.me
| E-mail: mansurtl.contact@gmail.com
| Instagram: @mansur_terla
| Telegram: @mansurtl_contact
|--------------------------------------------------------------------------
| Copyright (c)  ColibriPlus. All rights reserved.
|--------------------------------------------------------------------------
*/

use Illuminate\Support\Facades\Route;

Route::get('/chats', [App\Http\Controllers\Api\User\Chat\ChatController::class, 'getChats']);
Route::get('/archive', [App\Http\Controllers\Api\User\Chat\ChatController::class, 'getArchive']);
Route::get('/unread/count', [App\Http\Controllers\Api\User\Chat\ChatController::class, 'getUnreadCount']);
Route::post('/chats/create', [App\Http\Controllers\Api\User\Chat\ChatController::class, 'createChat']);

Route::get('/groups/create', [App\Http\Controllers\Api\User\Chat\GroupController::class, 'createDraftGroup']);
Route::get('/groups/{chatId}/edit', [App\Http\Controllers\Api\User\Chat\GroupController::class, 'editGroup']);
Route::get('/groups/{chatId}/show', [App\Http\Controllers\Api\User\Chat\GroupController::class, 'showGroup']);
Route::get('/groups/{chatId}/participants', [App\Http\Controllers\Api\User\Chat\GroupController::class, 'getGroupParticipants']);
Route::get('/groups/{chatId}/recent-joins', [App\Http\Controllers\Api\User\Chat\GroupController::class, 'getGroupRecentJoins']);
Route::post('/groups/avatar/update', [App\Http\Controllers\Api\User\Chat\GroupController::class, 'updateGroupAvatar']);
Route::post('/groups/update', [App\Http\Controllers\Api\User\Chat\GroupController::class, 'updateGroup']);
Route::delete('/groups/participant/delete', [App\Http\Controllers\Api\User\Chat\GroupController::class, 'deleteParticipants']);
Route::delete('/groups/delete', [App\Http\Controllers\Api\User\Chat\GroupController::class, 'deleteGroup']);
Route::post('/groups/invite/send', [App\Http\Controllers\Api\User\Chat\GroupController::class, 'inviteParticipants']);
Route::post('/groups/invite/search', [App\Http\Controllers\Api\User\Chat\GroupController::class, 'searchInvitees']);
Route::post('/groups/invite/accept', [App\Http\Controllers\Api\User\Chat\GroupController::class, 'acceptInvite']);
Route::post('/groups/invite/decline', [App\Http\Controllers\Api\User\Chat\GroupController::class, 'declineInvitation']);
Route::post('/groups/leave', [App\Http\Controllers\Api\User\Chat\GroupController::class, 'leaveGroup']);
Route::get('/groups/{chatId}/invite/pending', [App\Http\Controllers\Api\User\Chat\GroupController::class, 'getPendingInvitations']);


Route::get('/chats/requests', [App\Http\Controllers\Api\User\Chat\ChatController::class, 'getChatRequests']);
Route::get('/chats/requests/count', [App\Http\Controllers\Api\User\Chat\ChatController::class, 'getChatRequestsCount']);
Route::post('/chats/launch', [App\Http\Controllers\Api\User\Chat\ChatController::class, 'launchChat']);
Route::post('/chats/launcher-send', [App\Http\Controllers\Api\User\Chat\ChatController::class, 'launcherSendMessage']);
Route::post('/send', [App\Http\Controllers\Api\User\Chat\ChatController::class, 'sendMessage']);
Route::get('/chat/{chatId}', [App\Http\Controllers\Api\User\Chat\ChatController::class, 'getChatData']);
Route::post('/chat/message/add-reaction', [App\Http\Controllers\Api\User\Chat\ChatController::class, 'addReaction']);
Route::delete('/chat/message/delete', [App\Http\Controllers\Api\User\Chat\ChatController::class, 'deleteMessage']);
Route::get('/chat/{chatId}/messages', [App\Http\Controllers\Api\User\Chat\ChatController::class, 'getChatMessages']);
Route::get('/chat/{chatId}/participants', [App\Http\Controllers\Api\User\Chat\ChatController::class, 'getChatParticipants']);
Route::delete('/chat/{chatId}/clear', [App\Http\Controllers\Api\User\Chat\ChatController::class, 'clearConversation']);
Route::delete('/chat/{chatId}/delete', [App\Http\Controllers\Api\User\Chat\ChatController::class, 'deleteChat']);
Route::delete('/chat/{chatId}/archive', [App\Http\Controllers\Api\User\Chat\ChatController::class, 'archiveChat']);
Route::delete('/chat/{chatId}/unarchive', [App\Http\Controllers\Api\User\Chat\ChatController::class, 'unarchiveChat']);
Route::get('/chat/{chatId}/read', [App\Http\Controllers\Api\User\Chat\ChatController::class, 'markAsRead']);